<?php
/**
 * Scripts
 *
 * @package     AutomatorWP\Integrations\Thrive_Apprentice\Scripts
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Register admin scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_thrive_apprentice_admin_register_scripts() {

    // Use minified libraries if SCRIPT_DEBUG is turned off
    $suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

    // Scripts
    wp_register_script( 'automatorwp-thrive-apprentice-js', AUTOMATORWP_THRIVE_APPRENTICE_URL . 'assets/js/automatorwp-thrive-apprentice' . $suffix . '.js', array( 'jquery' ), AUTOMATORWP_THRIVE_APPRENTICE_VER, true );

}
add_action( 'admin_init', 'automatorwp_thrive_apprentice_admin_register_scripts' );

/**
 * Enqueue admin scripts
 *
 * @since       1.0.0
 *
 * @param string $hook
 *
 * @return      void
 */
function automatorwp_thrive_apprentice_admin_enqueue_scripts( $hook ) {

    // Scripts
    wp_localize_script( 'automatorwp-thrive-apprentice-js', 'automatorwp_thrive_apprentice', array(
        'nonce' => automatorwp_get_admin_nonce(),
    ) );

    wp_enqueue_script( 'automatorwp-thrive-apprentice-js' );

}
add_action( 'admin_enqueue_scripts', 'automatorwp_thrive_apprentice_admin_enqueue_scripts' );